# SABAL: Sparse Approximation-based Batch Active Learning

This repository contains the code for implementing [SABAL: Sparse Approximation-based Batch Active Learning]

## SABAL for Bayesian Active Learning

### Requirements
The code requires the following:
* Python >= 3.5
* torch >= 1.0
* torchvision >= 0.2.2
* numpy
* scipy
* sklearn
* pandas
* matplotlib
* gtimer

### Usage
To use Random acquisition,
```
!python ./torchvision_active.py --coreset 'Random' --dataset $dataset --seed $seed --batch_size $batch_size --budget $budget --init_num_labeled $init_num_labeled --num_features 256 --freq_summary 50 --weight_decay 5e-4 --weight_decay_theta 5e-4
```

To use BALD acquisition,
```
!python ./torchvision_active.py  --acq 'BALD' --coreset 'Argmax' --dataset $dataset --seed $seed --batch_size $batch_size --budget $budget --init_num_labeled $init_num_labeled --num_features 256 --freq_summary 50 --weight_decay 5e-4 --weight_decay_theta 5e-4
```

To use Bayesian Coreset acquisition,
```
!python ./torchvision_active_projections.py --coreset 'FW' --dataset $dataset --seed $seed --batch_size $batch_size --budget $budget --gamma 0.7 --num_projections $proj --init_num_labeled $init_num_labeled --num_features 256 --freq_summary 50 --weight_decay 5e-4 --weight_decay_theta 5e-4
```

To use SABAL acquisition,
```
!python ./torchvision_active_projections.py --coreset 'SparseCoreset' --dataset $dataset --seed $seed --batch_size $batch_size --budget $budget --num_projections $proj --alpha $alpha --beta $beta --optimization_method $optimization_method --zero_mean True --init_num_labeled $init_num_labeled --num_features 256 --freq_summary 50 --weight_decay 5e-4 --weight_decay_theta 5e-4
```

For example, to use SABAL acquisition and proximal IHT optimization method on Fashion MNIST dataset, starting with 1000 seed data and query 1000 data each iteration until budget reaches 10000:
```
!python ./torchvision_active_projections.py --coreset 'SparseCoreset' --dataset 'fashion_mnist' --seed 0 --batch_size 1000 --budget 10000 --num_projections 100 --alpha 1 --beta 1e-3 --optimization_method 'prox_iht' --zero_mean True --init_num_labeled 1000 --num_features 256 --freq_summary 50 --weight_decay 5e-4 --weight_decay_theta 5e-4
```

### Reference
This code uses part of the code from the following paper: 
[Bayesian Batch Active Learning as Sparse Subset Approximation].

## SABAL for General Active Learning

### Requirements
The code requires the following:
* Python >= 3.5
* torch >= 1.0
* torchvision >= 0.2.2
* numpy
* scipy
* sklearn
* matplotlib
* math
* pdb
* copy
* random
* time
* tqdm
* csv

### Usage
To run active learning approachs under the general setting:
```
!python ./main.py
```

For example, to use SABAL acquisition and greedy optimization method on SVHN dataset, starting with 1000 seed data and query 1000 data each iteration until budget reaches 6000, change the hyperparameters at line 33-61 in main.py:
```
dataset_name = 'SVHN'
method = 'SparseCoreset'
optimization_method = 'greedy'
model_name = 'VGG16'

model = VGG16(10)
num_seed_data = 1000
epoch_num = 150
batch_size = 128
num_queried_each_round = 1000
num_round_to_acquire = 6
num_class = 10
projection_method = 'gradient'
alpha = 1e-1
beta = 1e-1
```
